<?php
require_once('../general/db.php');
require_once('../general/response.php');
// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    //log the connection error
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

try {
    // create db query
    $partners_query = $readDB->prepare('SELECT * FROM partners');
    $partners_query->execute();

    // get row count
    $row_count = $partners_query->rowCount();

    if($row_count==0){
        $response = new Response();
        $response->setHttpStatusCode(404); //Not Found
        $response->setSuccess(false);
        $response->addMessage("Partners not found");
        $response->send();
        exit();
    }

    $partners = array();

    while ($row = $partners_query->fetch(PDO::FETCH_ASSOC)) {
        $image='https://digitalromania.ro/uploads/'.$row['post_image'];
        $partner = array(
            "name" => $row["post_title"],
            "shortDesc" => $row["short_desc"],
            "image" => $image,
            "url" => $row["url"],
        );
        $partners[]=$partner;
    }

    // set up response for successful return
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->toCache(false);
    $response->setData($partners);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Failed to get partners" . $ex);
    $response->send();
    exit;
}
?>
