<?php
require_once('../general/db.php');
require_once('../general/response.php');

// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    //log the connection error
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

try {
    // create db query
    $posts_query = $readDB->prepare('SELECT * FROM posts ORDER BY post_date DESC LIMIT 1,3');
    $posts_query->execute();

    // get row count
    $row_count = $posts_query->rowCount();
    $posts = array();

    while ($row = $posts_query->fetch(PDO::FETCH_ASSOC)) {
        $post_category_id = $row['post_category_id'];

        $post_category_query = $readDB->prepare("SELECT title, type, url FROM subs WHERE id = :post_category_id");
        $post_category_query->bindParam(":post_category_id", $post_category_id, PDO::PARAM_INT);
        $post_category_query->execute();

        $post_category_row_count = $post_category_query->rowCount();

        if ($post_category_row_count === 0) {
            // set up response for unsuccessful return
            $response = new Response();
            $response->setHttpStatusCode(404); //Not Found
            $response->setSuccess(false);
            $response->addMessage("Post category not found");
            $response->send();
            exit();
        }

        $post_category_row = $post_category_query->fetch(PDO::FETCH_ASSOC);
        $post_category = array(
            "title" => $post_category_row["title"],
            "type" => $post_category_row["type"],
            "url" => $post_category_row["url"]
        );


        // create new object for each row
        $postImage='https://digitalromania.ro/uploads/'.$row['post_image'];
        $post = array(
            'id'=> $row['post_id'],
            'postTitle' => $row['post_title'],
            'postImage' => $postImage,
            'url' => $row['url'],
            'postCategory' => $post_category,
        );
        // collect objects into an array
        $posts[] = $post;
    }

    // set up response for successful return
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->toCache(false);
    $response->setData($posts);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Failed to get recent posts" . $ex);
    $response->send();
    exit;
}
?>
