<?php
function slugify($text, $strict = true)
{
    $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8');
    // replace non letter or digits by -
    $text = preg_replace('~[^\\pL\d.]+~u', '-', $text);

    // trim
    $text = trim($text, '-');
    setlocale(LC_CTYPE, 'en_GB.utf8');
    // transliterate
    if (function_exists('iconv')) {
        $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    }

    // lowercase
    $text = strtolower($text);
    // remove unwanted characters
    $text = preg_replace('~[^-\w.]+~', '', $text);
    if (empty($text)) {
        return 'empty_$';
    }
    if ($strict) {
        $text = str_replace(".", "_", $text);
    }
    return $text;
}

function replaceSpecialCharacters($string)
{
    echo $string;
    $string = str_replace("Ä\x83", "ă", $string);
    $string = str_replace("Ä\x82", "Ă", $string);

    return $string;
}

function truncate_number($number, $precision = 2)
{

    // Zero causes issues, and no need to truncate
    if (0 == (int)$number) {
        return $number;
    }

    // Are we negative?
    $negative = $number / abs($number);

    // Cast the number to a positive to solve rounding
    $number = abs($number);

    // Calculate precision number for dividing / multiplying
    $precision = pow(10, $precision);

    // Run the math, re-applying the negative value to ensure
    // returns correctly negative / positive
    return floor($number * $precision) / $precision * $negative;
}

function get_key()
{
   return "G|e26o.e0~8s>]354g4U";
}

function encrypt_data($string)
{
    $simple_string = $string;
    $ciphering = "AES-128-CTR";
    $options = 0;
    $encryption_iv = '1234567891011121';
    $encryption_key = get_key();
    return openssl_encrypt($simple_string, $ciphering, $encryption_key, $options, $encryption_iv);
}

function decrypt_data($string)
{
    $simple_string = $string;
    $ciphering = "AES-128-CTR";
    $options = 0;
    $decryption_iv = '1234567891011121';
    $decryption_key = get_key();
    return openssl_decrypt($simple_string, $ciphering, $decryption_key, $options, $decryption_iv);
}


function webpImage($path, $cover = '', $quality = 100, $removeOld = false, $width = 0, $height = 0)
{
    if (strlen($cover)) {
        $source = $path . '/' . $cover;
    } else {
        $source = $path;
    }

    $imgSize = filesize("$source") / 1024;
    $dir = pathinfo($source, PATHINFO_DIRNAME);
    $name = pathinfo($source, PATHINFO_FILENAME);
    $destination = $dir . DIRECTORY_SEPARATOR . $name . '.webp';
    $info = getimagesize($source);
    $isAlpha = false;

    if ($width == 0) {
        $width = $info[0];
    }

    if ($height == 0) {
        $height = $info[1];
    }

    if ($info['mime'] == 'image/jpeg') {
        $image = imagecreatefromjpeg($source);
    } elseif ($isAlpha = $info['mime'] == 'image/gif') {
        $image = imagecreatefromgif($source);
    } elseif ($isAlpha = $info['mime'] == 'image/png') {
        $image = imagecreatefrompng($source);
    } else {
        //   copy($source, $destination);
        resize_image_webp(source_file: $source, destination_file: $destination, width: $width, height: $height, quality: $quality, crop: FALSE);
        return $source;
    }

    if ($isAlpha) {

        imagepalettetotruecolor($image);
        imagealphablending($image, true);
        imagesavealpha($image, true);

    }

    if ($imgSize <= 75) {
        $quality = 100;
        imagewebp($image, $destination, $quality);
        if ($removeOld)
            unlink($source);
    } else {
        imagewebp($image, $destination, $quality);


        if (resize_image_webp(source_file: $source, destination_file: $destination, width: $width, height: $height, quality: $quality, crop: FALSE)) {
            if ($removeOld)
                unlink($source);
        } else return false;
    }

    imagedestroy($image);


    return $destination;
}


function resize_image_webp($source_file, $destination_file, $width, $height, $quality, $crop = TRUE)
{
    list($current_width, $current_height) = getimagesize($source_file);
    if ($current_width && $current_height) {
        $rate = $current_width / $current_height;
        if ($crop) {
            if ($current_width > $current_height) {
                $current_width = ceil($current_width - ($current_width * abs($rate - $width / $height)));
            } else {
                $current_height = ceil($current_height - ($current_height * abs($rate - $width / $height)));
            }
            $newwidth = $width;
            $newheight = $height;
        } else {
            if ($width / $height > $rate) {
                $newwidth = $height * $rate;
                $newheight = $height;
            } else {
                $newheight = $width / $rate;
                $newwidth = $width;
            }
        }

        $source_file = str_replace(".jpg", '.webp', $source_file);
        $source_file = str_replace('.gif', '.webp', $source_file);
        $source_file = str_replace('.png', '.webp', $source_file);

        $info = getimagesize($source_file);

        if ($info['mime'] == 'image/jpeg') {
            if ($src_file = imagecreatefromjpeg($source_file)) ;
            $dst_file = imagecreatetruecolor($newwidth, $newheight);

        } elseif ($info['mime'] == 'image/gif') {
            if ($src_file = imagecreatefromgif($source_file)) ;
            $dst_file = imagecreatetruecolor($newwidth, $newheight);
        } elseif ($info['mime'] == 'image/png') {
            if ($src_file = imagecreatefrompng($source_file)) ;
            $dst_file = imagecreatetruecolor($newwidth, $newheight);
        } elseif ($info['mime'] == 'image/webp') {
            if ($src_file = imagecreatefromwebp($source_file)) ;
            $dst_file = imagecreatetruecolor($newwidth, $newheight);
            imagecopyresampled($dst_file, $src_file, 0, 0, 0, 0, $newwidth, $newheight, $current_width, $current_height);
            copy($source_file, $destination_file);
            return $source_file;
        } else {
            return $source_file;
        }

        imagecopyresampled($dst_file, $src_file, 0, 0, 0, 0, $newwidth, $newheight, $current_width, $current_height);
        return imagewebp($dst_file, $destination_file, $quality);
    } else return false;

}









