<?php
require_once('../general/db.php');
require_once('../general/response.php');
// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    //log the connection error
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

try {
    // create db query
    $post_categories_query = $readDB->prepare('SELECT * FROM categories');
    $post_categories_query->execute();

    // get row count
    $row_count = $post_categories_query->rowCount();

    if($row_count==0){
        $response = new Response();
        $response->setHttpStatusCode(404); //Not Found
        $response->setSuccess(false);
        $response->addMessage("Post categories not found");
        $response->send();
        exit();
    }

    $post_categories = array();

    while ($row = $post_categories_query->fetch(PDO::FETCH_ASSOC)) {
        $image='https://digitalromania.ro/uploads/'.$row['image'];
        $post_category = array(
            "title" => $row["cat_title"],
            "url" => $row["url"],
            "image" => $image,
        );
        $post_categories[]=$post_category;
    }

    // set up response for successful return
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->toCache(false);
    $response->setData($post_categories);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Failed to get categories" . $ex);
    $response->send();
    exit;
}
?>
