<?php
require_once('../general/db.php');
require_once('../general/response.php');

// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    // log connection error for troubleshooting and return a json error response
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    header('Access-Control-Allow-Methods: POST, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type');
    header('Access-Control-Max-Age: 86400');
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->send();
    exit;
}

try {
    // check request's content type header is JSON
    if ($_SERVER['CONTENT_TYPE'] !== 'application/json') {
        // set up response for unsuccessful request
        $response = new Response();
        $response->setHttpStatusCode(400);
        $response->setSuccess(false);
        $response->addMessage("Content Type header not set to JSON");
        $response->send();
        exit;
    }

    // get POST request body as the POSTed data will be JSON format
    $rawPostData = file_get_contents('php://input');
    if (!$jsonData = json_decode($rawPostData)) {
        // set up response for unsuccessful request
        $response = new Response();
        $response->setHttpStatusCode(400);
        $response->setSuccess(false);
        $response->addMessage("Request body is not valid JSON");
        $response->send();
        exit;
    }
    // check if post request contains title and completed data in body as these are mandatory
    if (!isset($jsonData->email)) {
        $response = new Response();
        $response->setHttpStatusCode(400);
        $response->setSuccess(false);
        (!isset($jsonData->email) ? $response->addMessage("Email field is mandatory and must be provided") : false);
        (!isset($jsonData->password) ? $response->addMessage("Password field is mandatory and must be provided") : false);
        $response->send();
        exit;
    }

    $email = $jsonData->email;
    $password = md5($jsonData->password);

    // create db querye
    $query = $readDB->prepare('SELECT * FROM newsletter WHERE client_email= :client_email AND client_password= :client_password');
    $query->bindParam(':client_email', $email, PDO::PARAM_STR);
    $query->bindParam(':client_password', $password, PDO::PARAM_STR);
    $query->execute();

    // get row count
    $rowCount = $query->rowCount();

    if ($rowCount === 0) {
        // set up response for unsuccessful return
        $response = new Response();
        $response->setHttpStatusCode(400);
        $response->setSuccess(false);
        $response->addMessage("Wrong credentails");
        $response->send();
        exit;
    }

    $row = $query->fetch(PDO::FETCH_ASSOC);
    $date = date('Y-m-d h:m:s');
    $token = bin2hex(openssl_random_pseudo_bytes(64));
    $valid_date = date("Y-m-d h:m:s", strtotime("+1 week"));

    $user = array(
        'email' => $row['client_email'],
        'token' => $token
    );

    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->addMessage("Login successful.");
    $response->setData($user);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Login failed. Please contact the developers. " . $ex);
    $response->send();
    exit;
}
