<?php
require_once('../general/db.php');
require_once('../general/response.php');

// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    //log the connection error
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

try {
    // create db query
    $general_query = $readDB->prepare('SELECT * FROM general');
    $general_query->execute();

    // get row count
    $row_count = $general_query->rowCount();
    if ($row_count === 0) {
        $response = new Response();
        $response->setHttpStatusCode(404); //Not Found
        $response->setSuccess(false);
        $response->addMessage("General details not found");
        $response->send();
        exit();
    }
    $row = $general_query->fetch(PDO::FETCH_ASSOC);

    // create new object for each row
    $aboutImage='https://digitalromania.ro/uploads/'.$row['about_image'];
    $image1='https://digitalromania.ro/uploads/'.$row['image1'];
    $image2='https://digitalromania.ro/uploads/'.$row['image2'];
    $about = array(
        'about' => $row['about'],
        'aboutImage' => $aboutImage,
        'image1' => $image1,
        'image2' => $image2,
        'link1' => $row['link1'],
        'link2' => $row['link2'],
    );

    // set up response for successful return
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->toCache(false);
    $response->setData($about);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Failed to get general details" . $ex);
    $response->send();
    exit;
}
?>
